<?php
/* --------------------------------------------------------------
   AutoUpdaterSFtpAdapter.inc.php 2018-09-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use phpseclib\Net\SFTP;
use League\Flysystem\Sftp\SftpAdapter as LeagueSFTP;

/**
 * Class AutoUpdaterSFtpAdapter
 */
class AutoUpdaterSFtpAdapter extends LeagueSFTP
{
	/**
	 * Change file permissions via sftp.
	 *
	 * @param string $path
	 * @param int $mode
	 *
	 * @return bool
	 */
	public function chmod($path, $mode)
	{
		$sftpPath = $this->getRoot() . ltrim($path, '/');
		if(false === @$this->has($sftpPath))
		{
			return false;
		}
		
		/** @var SFTP $connection */
		$connection = $this->getConnection();
		if(@$connection->chmod($mode, $sftpPath) === false)
		{
			return false;
		}
		
		return true;
	}
}
